﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;

namespace IndianHealthService.BMXNet.Model
{

    /// <summary>
    /// The user that established the connection to BMX either through the WinFramework dialogs or access/verify codes, or
    /// a user established through attach tho the EHR/VueCentric with the EhrFramework.
    /// <para>The user breaks down into who is it and what can they do with some identify and security key checing.</para>
    /// </summary>    
    public interface User
    {
        /// <summary>
        /// The DUZ aka IEN of the NEW Person File of this user
        /// </summary>
        String Duz { get; }
        /// <summary>
        /// A displayable name of the user
        /// </summary>
        String Name { get; }
        /// <summary>
        /// The division that this user to currently operating within
        /// </summary>
        Division Division { get; set; }

        /// <summary>
        /// Check aKey against the active RPMS keys for the user.  If the user has the PROGMODE key this
        /// method will always return true.
        /// </summary>
        /// <param name="aKey">The key name that is compared against the keys on the server</param>
        /// <returns>Return true if the user has the key</returns>
        bool HasSecurityKey(String aKey);

        /// <summary>
        /// Fetch from RPMS the user's current keys.  The user's
        /// division must be set before calling this metohd.
        /// </summary>
        /// <returns></returns>
        List<String> RequestKeys();

        /// <summary>
        /// Return a list of keys that the user does NOT have.  If the user has all of
        /// the keys then an empty list is returned
        /// </summary>
        /// <example>
        /// List&lt;String&gt; missingKeys=aUser.HasSecurityKeys(new string[] { "Key1","Key2" });
        /// if (missingKeys.Count==0) {
        ///     //Take a secured path
        /// } else {
        ///     MessageBox.Show(missingKeys);
        /// }
        /// </example>
        /// <remarks>
        /// The HasSecurityKeys appraoch does not give those with PROGMODE a free-pass since it compares
        /// the actual keys.  HasSecurityKeys uses RequestKeys
        /// </remarks>
        /// <param name="keys">a list of keys to compare against the user's keys</param>
        /// <returns>A list of keys the user does not have, empty of the user has them all</returns>
        List<String> HasSecurityKeys(string[] keys);
    }
}
